/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitor;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultProblemMonitor
implements ProblemMonitor,
VetoableChangeListener,
PropertyChangeListener {
    private static final String TRACE_MASKT = "XRVXDPMT";
    private static final String TRACE_MASKF = "XRVXDPMF";
    private static final String TRACE_MASKD = "XRVXDPMD";
    private boolean running = false;
    private List problems = null;
    private List problemsByType = null;
    private Map userData = null;
    private CommonProblem problemBeingVerified = null;

    public DefaultProblemMonitor() {
        Trace.trace(TRACE_MASKT, "<>DefaultProblemMonitor ctor");
    }

    public synchronized void clear() {
        this.problems = null;
        this.problemsByType = null;
    }

    public void init(Map userData) {
        this.userData = userData;
    }

    public synchronized void start() {
        Trace.trace(TRACE_MASKT, "->DefaultProblemMonitor.start()");
        try {
            this.clear();
            if (this.userData != null) {
                this.problemBeingVerified = (CommonProblem)this.userData.get("PROBLEM");
            }
            ProblemManager pm = ProblemManager.getProblemManager();
            pm.addVetoableChangeListener("ProblemOpenProperty", this);
            pm.addPropertyChangeListener("ProblemInventoryProperty", this);
            this.running = true;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "<-! DefaultProblemMonitor.start - exception caught and ignored: " + e);
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public synchronized boolean isStarted() {
        return this.running;
    }

    public synchronized List getDetectedProblems() {
        return this.problemsByType == null ? null : Collections.unmodifiableList(this.problemsByType);
    }

    public synchronized void stop() {
        Trace.trace(TRACE_MASKT, "<>DefaultProblemMonitor.stop");
        try {
            this.clear();
            ProblemManager pm = ProblemManager.getProblemManager();
            pm.removeVetoableChangeListener("ProblemOpenProperty", this);
            pm.removePropertyChangeListener("ProblemInventoryProperty", this);
            this.running = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "<-! DefaultProblemMonitor.stop - exception caught and ignored: " + e);
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public synchronized void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Problem p = (Problem)evt.getOldValue();
        if (p instanceof CommonProblem) {
            if (this.problemBeingVerified != null) {
                if (((CommonProblem)p).getFailingSystem() == this.problemBeingVerified.getFailingSystem()) {
                    Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.vetoableChange() vetoing open for problem with key=" + p.getUniqueKey());
                    if (this.problems == null) {
                        this.problems = new LinkedList();
                        this.problemsByType = new LinkedList();
                    }
                    if (!this.problems.contains(p)) {
                        this.problemsByType.add(new Object[]{p, ProblemMonitor.NEW_PROBLEM});
                        this.problems.add(p);
                    }
                    ((CommonProblem)p).setCallHome(false);
                } else {
                    Trace.trace(TRACE_MASKT, "<- DefaultProblemMonitor.vetoableChange() NO-OP - system mismatch between source and detected problem (" + this.problemBeingVerified.getFailingSystem() + "/" + ((CommonProblem)p).getFailingSystem() + ")");
                }
            } else {
                Trace.trace(TRACE_MASKT, "<- DefaultProblemMonitor.vetoableChange() NO-OP - there is no source problem set in the userdata Map to compare against");
            }
        } else {
            Trace.trace(TRACE_MASKT, "<- DefaultProblemMonitor.vetoableChange() NO-OP - The detected problem was not a CommonProblem(" + p + ")");
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Problem p = (Problem)evt.getNewValue();
        if (p instanceof CommonProblem) {
            if (this.problems == null) {
                this.problems = new LinkedList();
                this.problemsByType = new LinkedList();
            }
            if (!this.problems.contains(p)) {
                this.problemsByType.add(new Object[]{p, ProblemMonitor.DUP_PROBLEM});
                this.problems.add(p);
            }
        }
    }
}

